# G18_v2 — Explanation & Audit

## Goal
Validate **form invariance** (slope ~ 1, stable across re‑centering) and **amplitude consistency** (outer‑plateau mean unchanged by re‑centering) using a deterministic 1/r per‑shell scheduler.

## Why v1 failed
- Narrow linear bins, short H, and per‑center windows admitted lattice discreteness and edge proximity effects → high CVs, large amp_ratio shifts.

## v2 design changes
1. **Common interior radial window** using `r_max_glob = min(edge_radius(A), edge_radius(B)) − outer_margin` so both centers use identical shells.
2. **Heavier averaging**: `H=4096`, `shells_per_bin=24`, `outer_frac=0.75`; log‑fit with `n_log_bins=14`, `fit_mid_frac=0.60`.
3. **Bigger container**: `N=384`, margin `24`.

## Pipeline
1. Build integer‑radius shell counts around each center.
2. Run deterministic DDA (1/r) for H ticks; collect per‑shell fire counts.
3. **Slope**: log‑bins across `[r_min=8 .. r_max_glob=136]`, fit mid‑60% of bins.
4. **Plateau**: equal‑Δr bins (`Δr=24`) from `r_min=24` to the largest full bin ≤ `r_max_glob`; compute per‑annulus totals; report outer 75% CV + mean.
5. Apply acceptance gates and write audit.

## Final passing numbers
- **Result line**: `G18_v2 PASS=True slopeA=1.0020 slopeB=1.0020 Δslope=0.0000 cvA=0.0015 cvB=0.0015 Δcv=0.0000 amp_ratio=1.000 r_max_glob=136`
- **Per‑center**:
  - A: slope=1.001979, r2=1.000000, cv=0.001498, amp_mean=605.797201
  - B: slope=1.001979, r2=1.000000, cv=0.001498, amp_mean=605.797201
- **Pair**: Δslope=0.000000, Δcv=0.000000, amp_ratio(B/A)=1.000000
- **Gates**: per‑center OK = {'A': True, 'B': True}, invariance OK = True, amplitude OK = True, **PASS = True**

## Re‑run instructions
```bash
./scripts/run.sh
```
Outputs land under `G18_recentering_v2/<UTC>/outputs/` (metrics, audits, run_info).
